# Début programme de lecture de l'état enfoncé/relâché du bouton USR (avancé)
# (USR est l'acronyme de User pour signifier bouton utilisateur)

# Ce programme est une variation BoutonUSR_Basique.py .
# Ce programme démontre l'utilisation d'une fonction de rappel pour entrée tout-ou-rien.
# -> Consulter BoutonUSR_Basique.py pour une information plus détaillée sur le bouton USR.

# Nous importons le seul élément Arduino de pyfirmata2Ext
from pyfirmata2Ext import Arduino
from time import sleep

# Instanciation d'un objet représentant la carte Plug'Uino Uno.
# Arduino.AUTODETECT peut être remplacé par l'identifiant de port-série (ex : "COM1").
# Arduino.AUTODETECT peut ne pas fonctionner correctement avec les ports-serie Bluetooth.
plugUno = Arduino(Arduino.AUTODETECT)

# Active le mécanisme de récupération des différents états des E/S Plug'Uno.
plugUno.samplingOn(10) # 10 ms ( 100 Hz )

brocheBoutonUSR = plugUno.get_pin('d:12:ipu')
# -> d   : signifie mode tout-ou-rien
# -> 12  : numéro de la broche (2/3/4/5/6/7/8/9/10/11/12/13)
# -> ipu : mode Input_PullUp ou entrée avec résistance de rappel au 5V
# -------> peut etre 'i' si la résistance de rappel n'est pas désiré

# variable mise à jour par la fonction de rappel pour le chronométrage du temps appuyé
etatBoutonUSR = True; # True == bouton relâché

# Déclarer le fonction de rappel et son contenu.
def fonctionDeRappel(etat) :
    global etatBoutonUSR
    etatBoutonUSR = etat;
    print("Etat du bouton USR : "+("relâché" if etat else "enfoncé"))

# Indique a l'objet broche D12 d'appeler la fonction de rappel en cas de changement d'état.
brocheBoutonUSR.register_callback(fonctionDeRappel)

print(
    "\nLecture de l\'état du bouton USR par fonction de rappel."
    "\n(maintenir USR enfoncé plus de 3 secondes pour terminer)\n"
)

# Le programme principal est libre d'effectuer d'autres tâches
# Dans cette boucle si le bouton est pressé plus et 3 secondes et fermons le programme.
SEUIL_TEMPS_APPUIE_LONG = 3 # secondes
INTERVAL_TEMPS_COMPTAGE = 0.02 # secondes
compteur = 0
while True :
    
    # Si le bouton est enfoncé :
    if etatBoutonUSR is False :
        
        # commencer/continuer à compter le temps écoulé.
        compteur += INTERVAL_TEMPS_COMPTAGE
        
        # Si le bouton reste enfoncé plus de 3 secondes terminer le programme.
        if compteur > SEUIL_TEMPS_APPUIE_LONG :
            
            print("\nAppui long détecté.\nFermeture du programme.")
            
            # Fermer la connexion à Plug'Uino Uno avant de quitter.
            plugUno.exit()
            
            # Met fin a l'exécution du programme Python.
            exit()
            
    # Sinon, réinitialiser à 0 la variable de comptage (bouton au repos).
    else : compteur = 0
    sleep(INTERVAL_TEMPS_COMPTAGE)    

# Fin programme de lecture de l'état enfoncé/relâché du bouton USR (avancé)
